function [LdB,delta,E]=LambdaDB(E,m,Ep)
% LAMBDADB retourne la longueur d'onde de De Broglie d'un objet physique 
%    partir de son nergie totale, de sa masse et de(s) diffrentes 
%   valeurs de l'nergie potentielle Ep(i)  laquelle elle est soumise (i >= 1). 
%   Il retourne aussi la profondeur de pntration dans une rgion o
%   l'nergie potentielle est suprieure  l'nergie de l'objet physique.

%   [LdB,delta,E]=LambdaDB(E,m,Ep)
%       >> E        = Energie de l'objet physique (eV);
%       >> m        = Masse de l'objet physique (relative  la masse de l'lectron);
%       >> Ep       = Energie(s) potentielle(s) Ep(i) (eV);
%       << LdB      = Longueur d'onde de de Broglie (nm).
%       << delta    = Profondeur de pntration (nm).
%                           
%   Olivier Pujol : septembre 2013
%    
%% Vrifications

if (m<=0), error('La masse doit tre strictement positive !');end

% On vrifie qu'aucune valeur de E n'est gale  une valeur de Ep
for i=1:length(Ep)
    Ind=(abs(E-Ep(i))<eps); % Recherche des valeurs de E pour lesquelles E=Ep
    E=E(Ind~=1);            % On ne garde pas les valeurs de E correspondantes
end

clear i Ind

%% Calcul de LDB et Delta

LdB=cell(size(E));
delta=cell(size(E));
k=cell(size(E));
%
for n=1:length(E)
    k{n}=VectOnde(E(n),m,Ep);
        
    Ind=nan(1,length(k{n}));
    
    for ik=1:length(k{n}) 
        Ind(ik)=isreal(k{n}(ik));
    end

    LdB{n}=nan(1,length(k{n}));
    LdB{n}(Ind==1)=2*pi./(k{n}(Ind==1));
    delta{n}=nan(1,length(k{n}));
    delta{n}(Ind==0)=1./(2*imag(k{n}(Ind==0)));
    
end
%
if (length(E)==1)
    LdB=LdB{1};
    delta=delta{1};
end

return;